<?php $__env->startSection('pagename'); ?>
-
<?php if(empty($category)): ?>
<?php echo e(__('All')); ?>

<?php else: ?>
<?php echo e(convertUtf8($category->name)); ?>

<?php endif; ?>
<?php echo e(__('Portfolios')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->portfolios_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->portfolios_meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($bs->portfolio_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($bs->portfolio_subtitle)); ?>
<?php $__env->startSection('breadcrumb-link', __('Portfolios')); ?>

<?php $__env->startSection('content'); ?>
<!--    case lists start   -->
<div class="case-lists section-padding case-page pt-120 pb-110" id="masonry-portfolio">
  <div class="container">
    <?php if(serviceCategory()): ?>
      <div class="row">
        <div class="col-xl-12">
          <div class="filter-nav text-center mb-15">
            <ul class="filter-btn">
              <li data-filter="*" class="active">All</li>
              <?php $__currentLoopData = $scats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $scat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                  $filterValue = '.' . strtolower($scat->name);

                  if (str_contains($filterValue, ' ')) {
                    $filterValue = str_replace(' ', '-', $filterValue);
                  }
                ?>

                <li data-filter="<?php echo e($filterValue); ?>"><?php echo e(convertUtf8($scat->name)); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
        </div>
      </div>
    <?php endif; ?>

    <div class="cases masonry-row">
      <div class="row">
        <?php if(count($portfolios) == 0): ?>
          <div class="col-lg-12 py-5 bg-light text-center mb-4">
            <h3><?php echo e(__('NO PORTFOLIO FOUND')); ?></h3>
          </div>
        <?php else: ?>
          <?php $__currentLoopData = $portfolios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $portfolio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              if (!empty($portfolio->service->scategory)) {
                $portfolioCategory = $portfolio->service->scategory;

                $categoryName = strtolower($portfolioCategory->name);

                if (str_contains($categoryName, ' ')) {
                  $categoryName = str_replace(' ', '-', $categoryName);
                }
              }
            ?>

            <div class="col-lg-4 col-md-6 portfolio-column <?php echo e($categoryName); ?>">
              <div class="single-case lazy" data-bg="<?php echo e(asset('assets/front/img/portfolios/featured/'.$portfolio->featured_image)); ?>">
                <div class="outer-container">
                  <div class="inner-container">
                    <h4><?php echo e(strlen($portfolio->title) > 25 ? mb_substr($portfolio->title, 0, 25, 'utf-8') . '...' : $portfolio->title); ?></h4>
                    <?php if(!empty($portfolio->service)): ?>
                      <p><?php echo e($portfolio->service->title); ?></p>
                    <?php endif; ?>

                    <a href="<?php echo e(route('front.portfoliodetails', [$portfolio->slug])); ?>" class="readmore-btn"><span><?php echo e(__('Read More')); ?></span></a>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
      </div>
    </div>


  </div>
</div>
<!--    case lists end   -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
  $('#masonry-portfolio').imagesLoaded( function() {
    // items on button click
    $('.filter-btn').on('click', 'li', function () {
      var filterValue = $(this).attr('data-filter');
      $grid.isotope({
        filter: filterValue
      });
    });
    // menu active class
    $('.filter-btn li').on('click', function (e) {
      $(this).siblings('.active').removeClass('active');
      $(this).addClass('active');
      e.preventDefault();
    });
    var $grid = $('.masonry-row').isotope({
      itemSelector: '.portfolio-column',
      percentPosition: true,
      masonry: {
        columnWidth: 0
      }
    });
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/portfolios.blade.php ENDPATH**/ ?>