<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/nice-select.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagename'); ?>
    - <?php echo e(__('Events')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->events_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->events_meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($bs->event_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($bs->event_subtitle)); ?>
<?php $__env->startSection('breadcrumb-link', __('Events')); ?>

<?php $__env->startSection('content'); ?>
    <section class="event-search-section">
        <div class="container">
          <form action="<?php echo e(route('front.events')); ?>" method="GET" id="event-search">
            <div class="event-search-form pt-50 pb-50">
                <div class="row no-gutters">
                       <div class="col-lg-3">
                           <div class="form_group border-right">
                               <input type="text" class="form_control" name="title" placeholder="<?php echo e(__('Event Name')); ?>" value="<?php echo e(request()->input('title')); ?>">
                           </div>
                       </div>
                    <div class="col-lg-3">
                        <div class="form_group border-right">
                            <input type="text" class="form_control" name="location" placeholder="<?php echo e(__('Location')); ?>" value="<?php echo e(request()->input('location')); ?>">
                        </div>
                    </div>
                    <div class="col-lg-2">
                           <div class="form_group border-right">
                               <select name="category" onchange="document.getElementById('event-search').submit()">
                                   <option data-display="Catagory" value=""><?php echo e(__('Choose an option')); ?></option>
                                    <?php $__currentLoopData = $event_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($event_category->id); ?>" <?php echo e(request()->input('category') == $event_category->id ? 'selected' : ''); ?>><?php echo e($event_category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                               </select>
                           </div>
                       </div>

                       <div class="col-lg-2">
                           <div class="form_group">
                               <input type="date" name="date" placeholder="dd-mm-yyyy" class="form_control" value="<?php echo e(request()->input('date')); ?>" onchange="document.getElementById('event-search').submit()">
                           </div>
                       </div>
                       <div class="col-lg-2">
                           <div class="form_group">
                               <button class="main-btn" type="submit" style="height: 45px;justify-content: center;text-align: center;padding-top: 0;padding-bottom: 0;">
                                   <?php echo e(__('Search')); ?></button>
                           </div>
                       </div>

                </div>
            </div>
          </form>
        </div>
    </section><!--====== End Event-search Section ======-->
    <section class="event-area-section event-area-v2 bg_cover" id="event-filter" style="padding-bottom: 0px; padding-top: 10px;">
        <div class="container">
            <div class="contact-form-section pt-0 pb-1">
                <div class="container">
                    <div class="row justify-content-center text-center">
                        <div class="col-lg-6">
                            <!--<span class="section-title text-center"><?php echo e(__('Events')); ?></span>-->
                            <h2 class="section-summary px-0 text-center"><?php echo e(__('Upcoming Events')); ?></h2>
                        </div>
                    </div>
                </div>
            </div>

            <div class="filter_grid row">
                <?php if(count($events) > 0): ?>
                    <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 col-md-12 col-sm-12 grid-column cat1 cat4">
                            <div class="event-item">
                                <div class="event-img">
                                    <?php
                                        $images = json_decode($event->image, true);
                                    ?>
                                    <img data-src="<?php echo e((!empty($images)) ? asset('/assets/front/img/events/sliders/'.$images[0]) : ''); ?>" class="img-fluid lazy" alt="">
                                    <div class="event-overlay">
                                        <a href="<?php echo e(route('front.event_details',[$event->slug])); ?>" class="main-btn"><?php echo e(__('Learn More')); ?></a>
                                    </div>
                                </div>
                                <div class="event-content">
                                    <a class="cat c-1 base-bg text-white"><?php echo e($event->eventCategories->name); ?></a>
                                    <!--<a class="cat c-1" href="<?php echo e(route('front.events', ['category' => $event->eventCategories->id])); ?>">-->
                                    <!--    <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($event->cost); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>-->
                                    <!--</a>-->
                                    <h3><a href="<?php echo e(route('front.event_details',[$event->slug])); ?>">
                                        <?php echo e(strlen($event->title) > 30 ? mb_substr($event->title,0,30,'utf-8') . '...' : $event->title); ?>

                                    </a></h3>
                                    <div class="event-meta">
                                        <span><?php echo e($event->organizer); ?></span>
                                        <span><?php echo e(date_format(date_create($event->date),"d/m/Y")); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="col-12">
                        <div class="bg-secondary-py-5 text-center">
                            <h3><?php echo e(__('NO EVENT FOUND')); ?></h3>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <nav class="pagination-nav <?php echo e($events->total() > 1 ? 'mb-4' : ''); ?>">
                        <?php echo e($events->appends(['title' => request()->input('title'),'location' => request()->input('location'),'category' => request()->input('category'),'date' => request()->input('date')])->links()); ?>

                    </nav>
                </div>
            </div>
        </div>
    </section><!--====== End Event-area Section ======-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('/assets/front/js/jquery.nice-select.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/events.blade.php ENDPATH**/ ?>