<?php $__env->startSection('pagename'); ?>
- <?php echo e(__('Knowledgebase')); ?> - <?php echo e(convertUtf8($details->title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$details->meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$details->meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($bex->knowledgebase_details_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', strlen($details->title) > 30 ? mb_substr($details->title,0,30,'utf-8') . '...' : $details->title); ?>
<?php $__env->startSection('breadcrumb-link', __('Knowledgebase')); ?>

<?php $__env->startSection('content'); ?>


<section class="knowledge-requirements-section pt-140">
  <div class="container">
    <div class="row mb-60">
      <div class="col-lg-4">
        <div class="requirements-nav">
          <div
            class="accordion"
            id="accordionExample"
          >
            <?php $__currentLoopData = $article_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card">
              <div
                class="card-header"
                id="headingone"
              >
                <a
                  class="collapsed"
                  href="#"
                  data-toggle="collapse"
                  data-target="#<?php echo e('collapse' . $article_category->id); ?>"
                  aria-expanded="<?php echo e($details->article_category_id == $article_category->id ? 'true' : 'false'); ?>"
                  aria-controls="collapseone"
                >
                  <?php echo e($article_category->name); ?><span class="toggle_btn"></span>
                </a>
              </div>
              <div
                id="<?php echo e('collapse' . $article_category->id); ?>"
                class="collapse <?php echo e($details->article_category_id == $article_category->id ? 'show' : ''); ?>"
                aria-labelledby="headingOne"
                data-parent="#accordionExample"
                style=""
              >
                <div class="card-body">
                  <?php
                  $articles = App\Article::where('article_category_id', $article_category->id)
                  ->orderBy('id', 'desc')
                  ->get();
                  ?>

                  <?php if(count($articles) == 0): ?>
                  <ul class="list">
                    <li><a href="#"><?php echo e('0 ' . __('Articles in this category')); ?></a></li>
                  </ul>
                  <?php else: ?>
                  <ul class="list">
                    <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                      <a href="<?php echo e(route('front.knowledgebase_details', ['slug' => $article->slug])); ?>" class="<?php echo e($article->id == $details->id ? 'active' : ''); ?>">
                        <?php echo e(strlen($article->title) > 30 ? mb_substr($article->title, 0, 30, 'utf-8') . '...' : $article->title); ?>

                      </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
                  <?php endif; ?>
                </div>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      </div>

      <div class="col-lg-8">
        <div class="requirement-wrapper">
          <div class="requirement-wrapper-content">
            <div class="title">
              <h3><?php echo e($details->title); ?></h3>
            </div>
            <p><?php echo replaceBaseUrl($details->content); ?></p>
          </div>
        </div>
      </div>
    </div>

    <div class="post-share-date">
      <div class="row">
        <div class="col-lg-6 col-md-6">
          <span class="post-date">
            <?php $date = Carbon\Carbon::parse($details->created_at); ?>
            <i class="fa fa-clock-o"></i><?php echo e(__('Created') . ' : ' . $date->translatedFormat('jS F, Y')); ?>

          </span>
        </div>
        <div class="col-lg-6 col-md-6">
          <ul class="share-list">
            <li><span><?php echo e(__('Share')); ?>:</span></li>
            <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
            <li><a href="#"><i class="fab fa-twitter"></i></a></li>
            <li><a href="#"><i class="fab fa-pinterest-p"></i></a></li>
            <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/article_details.blade.php ENDPATH**/ ?>