<?php $__env->startSection('pagename'); ?>
- <?php echo e(__('Packages')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->packages_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->packages_meta_description"); ?>


<?php $__env->startSection('breadcrumb-title', $be->pricing_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', $be->pricing_subtitle); ?>
<?php $__env->startSection('breadcrumb-link', __('Packages')); ?>


<?php $__env->startSection('content'); ?>
<!--    Packages section start   -->
<div class="pricing-tables pricing-page" id="masonry-package">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-10">
        <?php if(count($categories) > 0 && $bex->package_category_status == 1): ?>
          <div class="filter-nav text-center mb-15">
            <ul class="filter-btn">
              <li data-filter="*" class="active"><?php echo e(__('All')); ?></li>
              <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $filterValue = "." . Str::slug($category->name);
                ?>

                <li data-filter="<?php echo e($filterValue); ?>"><?php echo e($category->name); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <div class="masonry-row">
      <div class="row">
        <?php if(count($packages) == 0): ?>
          <div class="col">
            <h3 class="text-center"><?php echo e(__('No Package Found!')); ?></h3>
          </div>
        <?php else: ?>
          <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              $packageCategory = $package->packageCategory()->first();
              if (!empty($packageCategory)) {
                  $categoryName = Str::slug($packageCategory->name);
              } else {
                  $categoryName = "";
              }
            ?>

            <div class="col-lg-4 col-md-6 package-column <?php echo e($categoryName); ?>">
              <div class="single-pricing-table">
                <span class="title"><?php echo e(convertUtf8($package->title)); ?></span>
                <?php if($bex->recurring_billing == 1): ?>
                  <small class="text-capitalize"><?php echo e($package->duration == 'monthly' ? __('Monthly') : __('Yearly')); ?></small>
                <?php endif; ?>
                <div class="price">
                  <h1>
                    <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e($package->price); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?>

                  </h1>
                </div>
                <div class="features">
                  <?php echo replaceBaseUrl(convertUtf8($package->description)); ?>

                </div>

                <?php if($bex->recurring_billing == 1): ?>
                  <?php if(auth()->guard()->check()): ?>
                    <?php if($activeSub->count() > 0 && empty($activeSub->first()->next_package_id)): ?>
                      <?php if($activeSub->first()->current_package_id == $package->id): ?>
                        <a href="<?php echo e(route('front.packageorder.index',$package->id)); ?>" class="pricing-btn"><?php echo e(__('Extend')); ?></a>
                      <?php else: ?>
                        <a href="<?php echo e(route('front.packageorder.index',$package->id)); ?>" class="pricing-btn"><?php echo e(__('Change')); ?></a>
                      <?php endif; ?>
                    <?php elseif($activeSub->count() == 0): ?>
                      <a href="<?php echo e(route('front.packageorder.index',$package->id)); ?>" class="pricing-btn"><?php echo e(__('Purchase')); ?></a>
                    <?php endif; ?>
                  <?php endif; ?>

                  <?php if(auth()->guard()->guest()): ?>
                  <a href="<?php echo e(route('front.packageorder.index',$package->id)); ?>" class="pricing-btn"><?php echo e(__('Purchase')); ?></a>
                  <?php endif; ?>
                <?php else: ?>
                  <?php if($package->order_status != 0): ?>
                    <?php
                      if($package->order_status == 1) {
                        $link = route('front.packageorder.index', $package->id);
                      } elseif ($package->order_status == 2) {
                        $link = $package->link;
                      }
                    ?>

                    <a href="<?php echo e($link); ?>" <?php if($package->order_status == 2): ?> target="_blank" <?php endif; ?> class="pricing-btn"><?php echo e(__('Place Order')); ?></a>
                  <?php endif; ?>
                <?php endif; ?>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<!--    Packages section end   -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
  $('#masonry-package').imagesLoaded( function() {
    // items on button click
    $('.filter-btn').on('click', 'li', function () {
      var filterValue = $(this).attr('data-filter');
      $grid.isotope({
        filter: filterValue
      });
    });
    // menu active class
    $('.filter-btn li').on('click', function (e) {
      $(this).siblings('.active').removeClass('active');
      $(this).addClass('active');
      e.preventDefault();
    });
    var $grid = $('.masonry-row').isotope({
      itemSelector: '.package-column',
      percentPosition: true,
      masonry: {
        columnWidth: 0
      }
    });
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/packages.blade.php ENDPATH**/ ?>