<?php $__env->startSection('pagename','- All Rss'); ?>

<?php $__env->startSection('meta-keywords', "$be->rss_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->rss_meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', $be->rss_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', $be->rss_subtitle); ?>
<?php $__env->startSection('breadcrumb-link', __('Latest RSS Feeds')); ?>

<?php $__env->startSection('content'); ?>

  <!--    blog lists start   -->
  <div class="blog-lists section-padding">
     <div class="container">
        <div class="row">
           <div class="col-lg-8">
              <div class="row">
                <?php if(count($rss_posts) == 0): ?>
                  <div class="col-md-12">
                    <div class="bg-light py-5">
                      <h3 class="text-center"><?php echo e(__('NO FEED FOUND')); ?></h3>
                    </div>
                  </div>
                <?php else: ?>
                  <?php $__currentLoopData = $rss_posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6">
                       <div class="single-blog">
                          <div class="blog-img-wrapper">
                             <img class="lazy" data-src="<?php echo e($post->photo); ?>" alt="">
                          </div>
                          <div class="blog-txt">
                            <?php
                                if (!empty($currentLang)) {
                                    $postDate = \Carbon\Carbon::parse($post->created_at)->locale("$currentLang->code");
                                } else {
                                    $postDate = \Carbon\Carbon::parse($post->created_at)->locale("en");
                                }

                                $postDate = $postDate->translatedFormat('jS F, Y');
                            ?>
                             <p class="date"><small><?php echo e(__('By')); ?> <span class="username"><?php echo e($post->category->feed_name); ?></span></small> | <small><?php echo e($postDate); ?></small> </p>

                             <h4 class="blog-title"><a href="<?php echo e(route('front.rssdetails', [$post->slug, $post->id])); ?>"><?php echo e(strlen($post->title) > 40 ? mb_substr($post->title, 0, 40, 'utf-8') . '...' : $post->title); ?></a></h4>

                             <p class="blog-summary"><?php echo (strlen(strip_tags($post->description)) > 100) ? mb_substr(strip_tags($post->description), 0, 100, 'utf-8') . '...' : strip_tags($post->description); ?></p>

                             <a href="<?php echo e(route('front.rssdetails', [$post->slug, $post->id])); ?>" class="readmore-btn"><span><?php echo e(__('Read More')); ?></span></a>

                          </div>
                       </div>
                    </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
              </div>
              <?php if($rss_posts->total() > 4): ?>
                <div class="row">
                   <div class="col-md-12">
                      <nav class="pagination-nav <?php echo e($rss_posts->total() > 6 ? 'mb-4' : ''); ?>">
                        <?php echo e($rss_posts->appends(['id' => request()->input('id')])->links()); ?>

                      </nav>
                   </div>
                </div>
              <?php endif; ?>
           </div>
           <!--    blog sidebar section start   -->
           <div class="col-lg-4">
              <div class="sidebar">
                 <div class="blog-sidebar-widgets category-widget">
                    <div class="category-lists job">
                       <h4><?php echo e(__('Categories')); ?></h4>
                       <ul>
                          <li class="single-category <?php echo e(empty(request()->input('id')) ? 'active' : ''); ?>"><a href="<?php echo e(route('front.rss')); ?>"><?php echo e(__('All')); ?></a></li>
                          <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $rcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <li class="single-category <?php echo e($rcat->id == request()->input('id') ? 'active' : ''); ?>"><a href="<?php echo e(route('front.rss',['id' => $rcat->id])); ?>"><?php echo e(convertUtf8($rcat->feed_name)); ?></a></li>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                       </ul>
                    </div>
                 </div>
                 <div class="subscribe-section">
                    <span><?php echo e(__('SUBSCRIBE')); ?></span>
                    <h3><?php echo e(__('SUBSCRIBE FOR NEWSLETTER')); ?></h3>
                    <form id="subscribeForm" class="subscribe-form" action="<?php echo e(route('front.subscribe')); ?>" method="POST">
                       <?php echo csrf_field(); ?>
                       <div class="form-element"><input name="email" type="email" placeholder="<?php echo e(__('Email')); ?>"></div>
                       <p id="erremail" class="text-danger mb-3 err-email"></p>
                       <div class="form-element"><input type="submit" value="<?php echo e(__('Subscribe')); ?>"></div>
                    </form>
                 </div>
              </div>
           </div>
           <!--    blog sidebar section end   -->
        </div>
     </div>
  </div>
  <!--    blog lists end   -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/rss.blade.php ENDPATH**/ ?>