<?php $__env->startSection('pagename'); ?>
  - <?php echo e(__('Client Feedback')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/jquery-ui.min.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/nice-select.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title', $bex->client_feedback_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', $bex->client_feedback_subtitle); ?>
<?php $__env->startSection('breadcrumb-link', __('Client Feedback')); ?>

<?php $__env->startSection('content'); ?>
  <section class="feedback-area-v1 pt-120 pb-120">
    <div class="container">
      <div class="row">

        <div class="col-lg-2"></div>
        <div class="col-lg-8">
          <div class="feedback-form">
            <form action="<?php echo e(route('store_feedback')); ?>" method="POST">
              <?php echo csrf_field(); ?>
              <div class="row">
                <input type="hidden" id="ratingId" name="rating">

                <div class="col-lg-12">
                  <div class="form_group">
                    <div class="rating-box">
                      <ul class="feedback-rating rating-1">
                        <li>
                          <a class="cursor-pointer" data-ratingVal="1"><i class="far fa-star"></i></a>
                        </li>
                      </ul>
                      <ul class="feedback-rating rating-2">
                        <li>
                          <a class="cursor-pointer" data-ratingVal="2"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="2"><i class="far fa-star"></i></a>
                        </li>
                      </ul>
                      <ul class="feedback-rating rating-3">
                        <li>
                          <a class="cursor-pointer" data-ratingVal="3"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="3"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="3"><i class="far fa-star"></i></a>
                        </li>
                      </ul>
                      <ul class="feedback-rating rating-4">
                        <li>
                          <a class="cursor-pointer" data-ratingVal="4"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="4"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="4"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="4"><i class="far fa-star"></i></a>
                        </li>
                      </ul>
                      <ul class="feedback-rating rating-5">
                        <li>
                          <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                        </li>
                        <li>
                          <a class="cursor-pointer" data-ratingVal="5"><i class="far fa-star"></i></a>
                        </li>
                      </ul>
                    </div>
                  </div>
                  <?php if($errors->has('rating')): ?>
                    <p class="text-danger mb-2 text-left"><?php echo e($errors->first('rating')); ?></p>
                  <?php endif; ?>
                </div>

                <div class="col-lg-12">
                  <div class="form_group">
                    <input type="text" class="form_control" placeholder="<?php echo e(__('Enter Name')); ?>" name="name">
                  </div>
                  <?php if($errors->has('name')): ?>
                    <p class="text-danger mb-2 text-left"><?php echo e($errors->first('name')); ?></p>
                  <?php endif; ?>
                </div>

                <div class="col-lg-12">
                  <div class="form_group">
                    <input type="email" class="form_control" placeholder="<?php echo e(__('Email Address')); ?>" name="email">
                  </div>
                  <?php if($errors->has('email')): ?>
                    <p class="text-danger mb-2 text-left"><?php echo e($errors->first('email')); ?></p>
                  <?php endif; ?>
                </div>

                <div class="col-lg-12">
                  <div class="form_group">
                    <input type="text" class="form_control" placeholder="<?php echo e(__('Subject')); ?>" name="subject">
                  </div>
                  <?php if($errors->has('subject')): ?>
                    <p class="text-danger mb-2 text-left"><?php echo e($errors->first('subject')); ?></p>
                  <?php endif; ?>
                </div>

                <div class="col-lg-12">
                  <textarea class="form_control pt-4" placeholder="<?php echo e(__('Write Feedback')); ?>" name="feedback"></textarea>
                  <?php if($errors->has('feedback')): ?>
                    <p class="text-danger mb-2 text-left"><?php echo e($errors->first('feedback')); ?></p>
                  <?php endif; ?>
                </div>

                <div class="col-lg-12">
                  <div class="form_group text-center">
                    <button class="main-btn btn base-bg"><?php echo e(__('Submit')); ?></button>
                  </div>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <script src="<?php echo e(asset('assets/front/js/jquery.ui.js')); ?>"></script>

  <script src="<?php echo e(asset('assets/front/js/jquery.nice-select.min.js')); ?>"></script>

  <script>
    $(document).ready(function () {
      // jquery nice select js
      $('select').niceSelect();
    });

    // get the rating (star) value in integer
    $(document).on('click', '.feedback-rating li a', function() {
      let ratingValue = $(this).attr('data-ratingVal');

      // first, remove star color from all the 'feedback-rating' class
      $('.feedback-rating li a i').removeClass('text-success');

      // second, add star color to the selected parent class
      let parentClass = `rating-${ratingValue}`;
      $('.' + parentClass + ' li a i').addClass('text-success');

      $('#ratingId').val(ratingValue);
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/client_feedback.blade.php ENDPATH**/ ?>