<?php $__env->startSection('pagename'); ?>
 - <?php echo e(convertUtf8($blog->title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$blog->meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$blog->meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($bs->blog_details_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', strlen($blog->title) > 30 ? mb_substr($blog->title, 0, 30, 'utf-8') . '...' : $blog->title); ?>
<?php $__env->startSection('breadcrumb-link', __('Blog Details')); ?>

<?php $__env->startSection('content'); ?>

  <!--    blog details section start   -->
  <div class="blog-details-section section-padding">
     <div class="container">
        <div class="row">
           <div class="<?php echo e($blog->sidebar == 1 ? 'col-lg-7' : 'col-12'); ?>">
              <div class="blog-details">
                 <img class="blog-details-img-1 lazy" data-src="<?php echo e(asset('assets/front/img/blogs/'.$blog->main_image)); ?>" alt="">
                 <small class="date"><?php echo e(date('F d, Y', strtotime($blog->created_at))); ?>  -  <?php echo e(__('BY')); ?> <?php echo e(__('Admin')); ?></small>
                 <h2 class="blog-details-title"><?php echo e(convertUtf8($blog->title)); ?></h2>
                 <div class="blog-details-body">
                   <?php echo replaceBaseUrl(convertUtf8($blog->content)); ?>

                 </div>
              </div>
              <div class="blog-share mb-5">
                 <ul>
                    <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>" class="facebook-share"><i class="fab fa-facebook-f"></i> <?php echo e(__('Share')); ?></a></li>
                    <li><a href="https://twitter.com/intent/tweet?text=my share text&amp;url=<?php echo e(urlencode(url()->current())); ?>" class="twitter-share"><i class="fab fa-twitter"></i> <?php echo e(__('Tweet')); ?></a></li>
                    <li><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode(url()->current())); ?>&amp;title=<?php echo e(convertUtf8($blog->title)); ?>" class="linkedin-share"><i class="fab fa-linkedin-in"></i> <?php echo e(__('Linkedin')); ?></a></li>
                 </ul>
              </div>

              <div class="comment-lists">
                <div id="disqus_thread"></div>
              </div>
           </div>
           <!--    blog sidebar section start   -->
           <?php if($blog->sidebar == 1): ?>
            <div class="col-lg-4">
                <div class="sidebar">
                    <div class="blog-sidebar-widgets">
                        <div class="searchbar-form-section">
                        <form action="<?php echo e(route('front.blogs', ['category' => request()->input('category'), 'month' => request()->input('month'), 'year' => request()->input('year')])); ?>" method="GET">
                            <div class="searchbar">
                                <input name="category" type="hidden" value="<?php echo e(request()->input('category')); ?>">
                                <input name="month" type="hidden" value="<?php echo e(request()->input('month')); ?>">
                                <input name="year" type="hidden" value="<?php echo e(request()->input('year')); ?>">
                                <input name="term" type="text" placeholder="<?php echo e(__('Search Blogs')); ?>" value="<?php echo e(request()->input('term')); ?>">
                                <button type="submit"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                        </div>
                    </div>
                    <div class="blog-sidebar-widgets category-widget">
                        <div class="category-lists job">
                        <h4><?php echo e(__('Categories')); ?></h4>
                        <ul>
                            <?php $__currentLoopData = $bcats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $bcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="single-category <?php if(request()->input('category') == $bcat->slug): ?> active <?php endif; ?>"><a href="<?php echo e(route('front.blogs', ['term'=>request()->input('term'), 'category'=>$bcat->slug, 'month' => request()->input('month'), 'year' => request()->input('year')])); ?>"><?php echo e(convertUtf8($bcat->name)); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        </div>
                    </div>
                    <div class="blog-sidebar-widgets category-widget">
                        <div class="category-lists job">
                        <h4><?php echo e(__('Archives')); ?></h4>
                        <ul>
                            <?php $__currentLoopData = $archives; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $archive): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                $myArr = explode('-', $archive->date);
                                $monthNum  = $myArr[0];
                                $dateObj   = DateTime::createFromFormat('!m', $monthNum);
                                $monthName = $dateObj->format('F');
                                ?>
                                <li class="single-category <?php if(request()->input('month') == $myArr[0] && request()->input('year') == $myArr[1]): ?> active <?php endif; ?>">
                                    <a href="<?php echo e(route('front.blogs', ['term'=>request()->input('term'), 'category'=>request()->input('category'),'month'=>$myArr[0], 'year'=>$myArr[1]])); ?>">

                                        <?php
                                            if (!empty($currentLang)) {
                                                $monthName = \Carbon\Carbon::parse($monthName)->locale("$currentLang->code");
                                                $year = \Carbon\Carbon::parse($myArr[1])->locale("$currentLang->code");
                                            } else {
                                                $monthName = \Carbon\Carbon::parse($monthName)->locale("en");
                                                $year = \Carbon\Carbon::parse($myArr[1])->locale("en");
                                            }

                                            $monthName = $monthName->translatedFormat('F');
                                            $year = $year->translatedFormat('Y');
                                        ?>

                                        <?php echo e($monthName); ?> <?php echo e($year); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        </div>
                    </div>
                    <div class="subscribe-section">
                        <span><?php echo e(__('SUBSCRIBE')); ?></span>
                        <h3><?php echo e(__('SUBSCRIBE FOR NEWSLETTER')); ?></h3>
                        <form id="subscribeForm" class="subscribe-form" action="<?php echo e(route('front.subscribe')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-element"><input name="email" type="email" placeholder="<?php echo e(__('Email')); ?>"></div>
                        <p id="erremail" class="text-danger mb-3 err-email"></p>
                        <div class="form-element"><input type="submit" value="<?php echo e(__('Subscribe')); ?>"></div>
                        </form>
                    </div>
                </div>
            </div>
           <?php endif; ?>
           <!--    blog sidebar section end   -->
        </div>
     </div>
  </div>
  <!--    blog details section end   -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php if($bs->is_disqus == 1): ?>
<?php echo $bs->disqus_script; ?>

<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/blog-details.blade.php ENDPATH**/ ?>