<?php $__env->startSection('pagename'); ?>
    - <?php echo e(__('Causes')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->causes_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->causes_meta_description"); ?>

<?php $__env->startSection('breadcrumb-title', $bs->cause_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', $bs->cause_subtitle); ?>
<?php $__env->startSection('breadcrumb-link', __('Causes')); ?>

<?php $__env->startSection('content'); ?>
    <!--====== Start charity-causes Section ======-->
    <section class="charity-causes pt-120 pb-50">
        <div class="container">
            <div class="row">
                <?php if(count($causes) > 0): ?>
                    <?php $__currentLoopData = $causes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cause): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div class="causes-box mb-40">
                                <div class="causes-img">
                                    <?php if(!empty($cause->image)): ?>
                                        <img class="lazy" data-src="<?php echo e(asset('/assets/front/img/donations/'.$cause->image)); ?>" alt="">
                                    <?php endif; ?>
                                    <div class="causes-overlay">
                                        <div class="goal">
                                            <span><?php echo e(__('Goal')); ?><br><?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e(convertUtf8($cause->goal_amount)); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="causes-content">
                                    <div class="single-progress">
                                        <div class="single-progress-bar">
                                            <div class="progress-bar-inner width-20" data-aos="fade-right" style="width: <?php echo e($cause->goal_percentage == 0 ? 4 : $cause->goal_percentage); ?>%">
                                                <div class="progress-bar-style"><?php echo e($cause->goal_percentage); ?>%</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="content-info">
                                        <h3><a href="<?php echo e(route('front.cause_details', [$cause->slug])); ?>"><?php echo e(strlen($cause->title) > 30 ? mb_substr($cause->title, 0, 30, 'utf-8') . '...' : $cause->title); ?></a></h3>
                                        <div class="causes-meta">
                                            <p><span><?php echo e(__('Goal')); ?></span>- <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e(convertUtf8($cause->goal_amount)); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></p>
                                            <p><span><?php echo e(__('Raised')); ?></span>- <?php echo e($bex->base_currency_symbol_position == 'left' ? $bex->base_currency_symbol : ''); ?><?php echo e(convertUtf8($cause->raised_amount)); ?><?php echo e($bex->base_currency_symbol_position == 'right' ? $bex->base_currency_symbol : ''); ?></p>
                                        </div>
                                        <p><?php echo (strlen(strip_tags($cause->content)) > 100) ? mb_substr(strip_tags($cause->content), 0, 100, 'utf-8') . '...' : strip_tags($cause->content); ?></p>
                                        <a href="<?php echo e(route('front.cause_details', [$cause->slug])); ?>" class="readmore-btn"><span><?php echo e(__('Read More')); ?></span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <nav class="pagination-nav <?php echo e($causes->total() > 1 ? 'mb-4' : ''); ?>">
                        <?php echo e($causes->appends(['language' => request()->input('language')])->links()); ?>

                    </nav>
                </div>
            </div>
        </div>
    </section><!--====== End charity-causes Section ======-->
    <?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/causes.blade.php ENDPATH**/ ?>