<?php $__env->startSection('pagename'); ?>
 -
 <?php if(empty($category)): ?>
 <?php echo e(__('All')); ?>

 <?php else: ?>
 <?php echo e($category->name); ?>

 <?php endif; ?>
 <?php echo e(__('Services')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-keywords', "$be->services_meta_keywords"); ?>
<?php $__env->startSection('meta-description', "$be->services_meta_description"); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startSection('breadcrumb-title', convertUtf8($bs->service_title)); ?>
<?php $__env->startSection('breadcrumb-subtitle', convertUtf8($bs->service_subtitle)); ?>
<?php $__env->startSection('breadcrumb-link', __('Services')); ?>


  <!--    services section start   -->
  <div class="service-section">
     <div class="container">
        <div class="row">
           <div class="col-lg-8">
              <div class="row">
                <?php if(count($services) == 0): ?>
                  <div class="col-12 bg-light py-5">
                    <h3 class="text-center"><?php echo e(__('NO SERVICE FOUND')); ?></h3>
                  </div>
                <?php else: ?>
                  <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6">
                       <div class="single-service">
                          <div class="service-img-wrapper">
                             <img class="lazy" data-src="<?php echo e(asset('assets/front/img/services/'.$service->main_image)); ?>" alt="<?php echo e(convertUtf8($service->title)); ?>">
                          </div>
                          <div class="service-txt">

                            <h4 class="service-title"><a <?php if($service->details_page_status == 1): ?> href="<?php echo e(route('front.servicedetails', [$service->slug])); ?>" <?php endif; ?>><?php echo e(convertUtf8(strlen($service->title)) > 18 ? convertUtf8(substr($service->title, 0, 18)) . '...' : convertUtf8($service->title)); ?></a></h4>

                            <p class="service-summary">
                                <?php if(strlen($service->summary) > 120): ?>
                                   <?php echo e(mb_substr($service->summary, 0, 120, 'utf-8')); ?><span style="display: none;"><?php echo e(mb_substr($service->summary, 120, null, 'utf-8')); ?></span>
                                   <a href="#" class="see-more"><?php echo e(__('see more')); ?>...</a>
                                <?php else: ?>
                                   <?php echo e($service->summary); ?>

                                <?php endif; ?>
                            </p>

                             <?php if($service->details_page_status == 1): ?>
                             <a href="<?php echo e(route('front.servicedetails', [$service->slug])); ?>" class="readmore-btn"><span><?php echo e(__('Read More')); ?></span></a>
                             <?php endif; ?>

                          </div>
                       </div>
                    </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
              </div>
              <div class="row">
                 <div class="col-md-12">
                    <nav class="pagination-nav">
                      <?php echo e($services->appends(['category' => request()->input('category'), 'term' => request()->input('term')])->links()); ?>

                    </nav>
                 </div>
              </div>
           </div>
           <!--    service sidebar start   -->
           <div class="col-lg-4">
             <div class="blog-sidebar-widgets">
                <div class="searchbar-form-section">
                   <form action="<?php echo e(route('front.services')); ?>">
                      <div class="searchbar">
                         <input name="category" type="hidden" value="<?php echo e(request()->input('category')); ?>">
                         <input name="term" type="text" placeholder="<?php echo e(__('Search Services')); ?>" value="<?php echo e(request()->input('term')); ?>">
                         <button type="submit"><i class="fa fa-search"></i></button>
                      </div>
                   </form>
                </div>
             </div>
             <?php if(serviceCategory()): ?>
             <div class="blog-sidebar-widgets category-widget">
                <div class="category-lists job">
                   <h4><?php echo e(__('Categories')); ?></h4>
                   <ul>
                     <?php $__currentLoopData = $scats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $scat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       <li class="single-category <?php echo e($scat->id == request()->input('category') ? 'active' : ''); ?>"><a href="<?php echo e(route('front.services', ['category' => $scat->id, 'term'=>request()->input('term')])); ?>"><?php echo e(convertUtf8($scat->name)); ?></a></li>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </ul>
                </div>
             </div>
             <?php endif; ?>
             <div class="subscribe-section">
                <span><?php echo e(__('SUBSCRIBE')); ?></span>
                <h3><?php echo e(__('SUBSCRIBE FOR NEWSLETTER')); ?></h3>
                <form id="subscribeForm" class="subscribe-form" action="<?php echo e(route('front.subscribe')); ?>" method="POST">
                   <?php echo csrf_field(); ?>
                   <div class="form-element"><input name="email" type="email" placeholder="<?php echo e(__('Email')); ?>"></div>
                   <p id="erremail" class="text-danger mb-3 err-email"></p>
                   <div class="form-element"><input type="submit" value="<?php echo e(__('Subscribe')); ?>"></div>
                </form>
             </div>
           </div>
           <!--    service sidebar end   -->
        </div>
     </div>
  </div>
  <!--    services section end   -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/services.blade.php ENDPATH**/ ?>