<?php $__env->startSection('pagename'); ?>
  - <?php echo e(__('All Courses')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
  <link
    rel="stylesheet"
    href="<?php echo e(asset('assets/front/css/jquery-ui.min.css')); ?>"
  >

  <link
    rel="stylesheet"
    href="<?php echo e(asset('assets/front/css/nice-select.css')); ?>"
  >
  <style>
      .nice-select {
          width: 100%;
      }
  </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title', $bex->course_title); ?>
<?php $__env->startSection('breadcrumb-subtitle', $bex->course_subtitle); ?>
<?php $__env->startSection('breadcrumb-link', __('Courses')); ?>

<?php $__env->startSection('content'); ?>

  
  <?php if(count($featured_courses) > 0): ?>
  <section
    class="course-area-v1 pt-80 pb-120 bg_cover"
    style="background-image: url(assets/front/img/counter-bg-1.png);"
  >
    <div class="container">
      <?php if(count($featured_courses) == 0): ?>
        <div class="row">
          <div class="col">
            <div class="py-5 text-center">
              <h3 class="text-light"><?php echo e(__('No Featured Course Found!')); ?></h3>
            </div>
          </div>
        </div>
      <?php else: ?>
        <div class="row">
            <div class="col">
                <div class="py-5 text-center">
                    <h2 class="text-light"><?php echo e(__('OUR FEATURED COURSES')); ?></h2>
                </div>
            </div>
        </div>
        <div class="course-slide row">
          <?php $__currentLoopData = $featured_courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featured_course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="course-item col-lg-4">
                <div class="course-img">
                    <img data-src="<?php echo e(asset('assets/front/img/courses/' . $featured_course->course_image)); ?>" class="img-fluid lazy" alt="" >
                    <a href="<?php echo e(route('course_details', ['slug' => $featured_course->slug])); ?>" class="course-overlay">
                        <?php if($bex->is_course_rating == 1): ?>
                            <div class="rating">
                                <p><i class="fas fa-star"></i><?php echo e(round($featured_course->review()->avg('rating'), 2)); ?> <span>(<?php echo e($featured_course->review()->count()); ?>)</span></p>
                            </div>
                        <?php endif; ?>
                        <div class="categorie-box">
                            <a
                                href="<?php echo e(route('courses', ['category_id' => $featured_course->course_category_id])); ?>"
                                class="main-btn"
                            ><?php echo e($featured_course->courseCategory->name); ?></a>
                        </div>
                    </a>
                </div>

              <div class="course-content">
                <h3>
                  <a href="<?php echo e(route('course_details', ['slug' => $featured_course->slug])); ?>">
                    <?php echo e(strlen($featured_course->title) > 30 ? mb_substr($featured_course->title, 0, 30, 'utf-8') . '...' : $featured_course->title); ?>

                  </a>
                </h3>
                <div class="course-admin-price">
                    <div class="admin">
                      <img src="<?php echo e(asset('assets/front/img/instructors/' . $featured_course->instructor_image)); ?>" class="img-fluid" alt="">
                      <span><a><?php echo e($featured_course->instructor_name); ?></a></span>
                    </div>
                    <div class="price">
                      <?php if(empty($featured_course->current_price)): ?>
                        <span><?php echo e(__('Free')); ?></span>
                      <?php else: ?>
                          <span><?php echo e($bse->base_currency_symbol_position == 'left' ? $bse->base_currency_symbol : ''); ?> <?php echo e($featured_course->current_price); ?> <?php echo e($bse->base_currency_symbol_position == 'right' ? $bse->base_currency_symbol : ''); ?></span>
                          <?php if(!empty($featured_course->previous_price)): ?>
                              <span class="pre-price"><del><?php echo e($bse->base_currency_symbol_position == 'left' ? $bse->base_currency_symbol : ''); ?> <?php echo e($featured_course->previous_price); ?> <?php echo e($bse->base_currency_symbol_position == 'right' ? $bse->base_currency_symbol : ''); ?></del></span>
                          <?php endif; ?>
                      <?php endif; ?>
                    </div>
                  </div>
                <div class="course-meta">
                  <span><i class="fas fa-users"></i><?php echo e($featured_course->coursePurchase()->where('payment_status', 'Completed')->count()); ?> <?php echo e(__('Students')); ?></span>
                  <span><i class="far fa-clock"></i><?php echo e($featured_course->duration); ?></span>
                </div>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      <?php endif; ?>
    </div>
  </section>
  
  <?php endif; ?>

  
  <section class="courses-grid-style pt-120 pb-80">
    <div class="container">
      <div class="row">
        <div class="col-lg-4">
          <div class="courses-sidebar">
            <div class="widget-box courses-type-widget">
              <h4><?php echo e(__('Course Type')); ?></h4>
              <div class="single_radio">
                <input
                  type="radio"
                  id="radio1"
                  class="course-type"
                  name="checked_value"
                  value="all"
                  <?php echo e(request()->input('checked_value') == 'all' || empty(request()->input('checked_value')) ? 'checked' : ''); ?>

                >
                <label for="radio1"><span class="circle"></span><span class="text"><?php echo e(__('All Courses')); ?></span></label>
              </div>
              <div class="single_radio">
                <input
                  type="radio"
                  id="radio2"
                  class="course-type"
                  name="checked_value"
                  value="free"
                  <?php echo e(request()->input('checked_value') == 'free' ? 'checked' : ''); ?>

                >
                <label for="radio2"><span class="circle"></span><span class="text"><?php echo e(__('Free Courses')); ?></span></label>
              </div>
              <div class="single_radio">
                <input
                  type="radio"
                  id="radio3"
                  class="course-type"
                  name="checked_value"
                  value="premium"
                  <?php echo e(request()->input('checked_value') == 'premium' ? 'checked' : ''); ?>

                >
                <label for="radio3"><span class="circle"></span><span class="text"><?php echo e(__('Premium Courses')); ?></span></label>
              </div>
            </div>

            <div class="widget-box categories-widget">
              <h4><?php echo e(__('Categories')); ?></h4>
              <ul>
                <li class="<?php echo e(empty(request()->input('category_id')) ? 'active-search' : ''); ?>">
                    <a
                      data-href=""
                      id="categoryId"
                    ><?php echo e(__('All')); ?> <span><?php echo e('(' . $courseCount . ')'); ?></span></a>
                </li>
                <?php $__currentLoopData = $course_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="<?php echo e(request()->input('category_id') == $course_category->id ? 'active-search' : ''); ?>">
                  <a
                    data-href="<?php echo e($course_category->id); ?>"
                    id="categoryId"
                  ><?php echo e(convertUtf8($course_category->name)); ?> <span><?php echo e('(' . $course_category->courses()->count() . ')'); ?></span></a>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>


            <?php if($bex->is_course_rating == 1): ?>
            <div class="widget-box courses-type-widget">
              <h4><?php echo e(__('Filter By Rating')); ?></h4>
              <div class="single_radio">
                <input
                  type="radio"
                  id="ratingAll"
                  class="rating-filter"
                  name="radio"
                  value="all"
                  <?php echo e(request()->input('rating') == 'all' || request()->input('rating') == '' ? 'checked' : ''); ?>

                >
                <label for="ratingAll"><span class="circle"></span><span class="text"><?php echo e(__('Show All')); ?></span></label>
              </div>
              <div class="single_radio">
                <input
                  type="radio"
                  id="rating5"
                  class="rating-filter"
                  name="radio"
                  value="5"
                  <?php echo e(request()->input('rating') == 5 ? 'checked' : ''); ?>

                >
                <label for="rating5"><span class="circle"></span><span class="text"><?php echo e(__('5 Star')); ?></span></label>
              </div>
              <div class="single_radio">
                <input
                  type="radio"
                  id="rating4"
                  class="rating-filter"
                  name="radio"
                  value="4"
                  <?php echo e(request()->input('rating') == 4 ? 'checked' : ''); ?>

                >
                <label for="rating4"><span class="circle"></span><span class="text"><?php echo e(__('4 Star and higher')); ?></span></label>
              </div>
              <div class="single_radio">
                <input
                  type="radio"
                  id="rating3"
                  class="rating-filter"
                  name="radio"
                  value="3"
                  <?php echo e(request()->input('rating') == 3 ? 'checked' : ''); ?>

                >
                <label for="rating3"><span class="circle"></span><span class="text"><?php echo e(__('3 Star and higher')); ?></span></label>
              </div>
              <div class="single_radio">
                <input
                  type="radio"
                  id="rating2"
                  class="rating-filter"
                  name="radio"
                  value="2"
                  <?php echo e(request()->input('rating') == 2 ? 'checked' : ''); ?>

                >
                <label for="rating2"><span class="circle"></span><span class="text"><?php echo e(__('2 Star and higher')); ?></span></label>
              </div>
              <div class="single_radio">
                <input
                  type="radio"
                  id="rating1"
                  class="rating-filter"
                  name="radio"
                  value=1
                  <?php echo e(request()->input('rating') == 1 ? 'checked' : ''); ?>

                >
                <label for="rating1"><span class="circle"></span><span class="text"><?php echo e(__('1 Star and higher')); ?></span></label>
              </div>
            </div>
            <?php endif; ?>

            <div class="widget-box price-range-widget">
              <h4><?php echo e(__('Filter By Price')); ?></h4>
              <div id="slider-range"></div>
              <label for="amount"><?php echo e(__('Price') . ':'); ?></label>
              <input
                type="text"
                id="amount"
              >
            </div>
          </div>
        </div>

        <div class="col-lg-8">
          <div class="course-filter mb-50">
            <div class="row">
              <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="form_group">
                  <select id="filterType">
                    <option selected disabled><?php echo e(__('Filter')); ?></option>
                    <option value="new" <?php echo e(request()->input('filterValue') == 'new' ? 'selected' : ''); ?>><?php echo e(__('New Courses')); ?></option>
                    <option value="old" <?php echo e(request()->input('filterValue') == 'old' ? 'selected' : ''); ?>><?php echo e(__('Old Courses')); ?></option>

                    <?php if($bex->is_course_rating == 1): ?>
                    <option value="high-to-low-rating" <?php echo e(request()->input('filterValue') == 'high-to-low-rating' ? 'selected' : ''); ?>><?php echo e(__('High to Low Rating')); ?></option>
                    <?php endif; ?>

                    <option value="high-to-low" <?php echo e(request()->input('filterValue') == 'high-to-low' ? 'selected' : ''); ?>><?php echo e(__('High To Low Price')); ?></option>
                    <option value="low-to-high" <?php echo e(request()->input('filterValue') == 'low-to-high' ? 'selected' : ''); ?>><?php echo e(__('Low To High Price')); ?></option>
                  </select>
                </div>
              </div>

              <div class="col-lg-9 col-md-6 col-sm-12">
                <div class="form_group search_group <?php echo e($rtl == 1 ? 'float-left' : ''); ?>">
                  <i
                    class="fas fa-search"
                    id="search-input-btn"
                  ></i>
                  <input
                    type="search"
                    class="form_control"
                    id="searchInput"
                    placeholder="<?php echo e(__('Search By Course Name')); ?>"
                    name="search"
                    value="<?php echo e(request()->input('search') ? request()->input('search') : ''); ?>"
                  >
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <?php if(count($courses) == 0): ?>
              <div class="col-md-12">
                <div class="py-5">
                  <h3 class="text-center"><?php echo e(__('No Course Found!')); ?></h3>
                </div>
              </div>
            <?php else: ?>
              <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="col-md-6 col-sm-12">
                <div class="course-item">
                  <div class="course-img">
                    <img data-src="<?php echo e(asset('assets/front/img/courses/' . $course->course_image)); ?>" class="img-fluid lazy" alt="" >
                    <a href="<?php echo e(route('course_details', ['slug' => $course->slug])); ?>" class="course-overlay">

                        <?php if($bex->is_course_rating == 1): ?>
                        <div class="rating">
                            <p><i class="fas fa-star"></i><?php echo e(round($course->review()->avg('rating'), 2)); ?> <span>(<?php echo e($course->review()->count()); ?>)</span></p>
                        </div>
                        <?php endif; ?>
                        <div class="categorie-box">
                            <a
                                href="<?php echo e(route('courses', ['category_id' => $course->course_category_id])); ?>"
                                class="main-btn"
                            ><?php echo e($course->courseCategory->name); ?></a>
                        </div>
                    </a>
                  </div>
                  <div class="course-content">
                    <h3>
                      <a href="<?php echo e(route('course_details', ['slug' => $course->slug])); ?>">
                        <?php echo e(strlen($course->title) > 30 ? mb_substr($course->title, 0, 30, 'utf-8') . '...' : $course->title); ?>

                      </a>
                    </h3>
                    <div class="course-admin-price">
                      <div class="admin">
                        <img src="<?php echo e(asset('assets/front/img/instructors/' . $course->instructor_image)); ?>" class="img-fluid" alt="">
                        <span><a><?php echo e($course->instructor_name); ?></a></span>
                      </div>
                      <div class="price">
                        <?php if(empty($course->current_price)): ?>
                          <span><?php echo e(__('Free')); ?></span>
                        <?php else: ?>
                            <span><?php echo e($bse->base_currency_symbol_position == 'left' ? $bse->base_currency_symbol : ''); ?> <?php echo e($course->current_price); ?> <?php echo e($bse->base_currency_symbol_position == 'right' ? $bse->base_currency_symbol : ''); ?></span>
                            <?php if(!empty($course->previous_price)): ?>
                                <span class="pre-price"><del><?php echo e($bse->base_currency_symbol_position == 'left' ? $bse->base_currency_symbol : ''); ?> <?php echo e($course->previous_price); ?> <?php echo e($bse->base_currency_symbol_position == 'right' ? $bse->base_currency_symbol : ''); ?></del></span>
                            <?php endif; ?>
                        <?php endif; ?>
                      </div>
                    </div>
                    <div class="course-meta">
                      <span><i class="fas fa-users"></i><?php echo e($course->coursePurchase()->where('payment_status', 'Completed')->count()); ?> <?php echo e(__('Students')); ?></span>
                      <span><i class="far fa-clock"></i><?php echo e($course->duration); ?></span>
                    </div>
                  </div>
                </div>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </div>

          <div class="row">
            <div class="col-md-12">
              <nav class="pagination-nav mb-3">
                <?php echo e($courses->appends([
                  'search' => request()->input('search'),
                  'category_id' => request()->input('category_id'),
                  'checked_value' => request()->input('checked_value'),
                  'rating' => request()->input('rating'),
                  'minValue' => request()->input('minValue'),
                  'maxValue' => request()->input('maxValue'),
                  'filterValue' => request()->input('filterValue')
                ])->links()); ?>

              </nav>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  

  
  <form id="searchForm" class="d-none" action="<?php echo e(route('courses')); ?>" method="GET">
    <input
      type="hidden"
      id="searchKey"
      name="search"
      value="<?php echo e(!empty(request()->input('search')) ? request()->input('search') : ''); ?>"
    >
    <input
      type="hidden"
      id="categoryKey"
      name="category_id"
      value="<?php echo e(!empty(request()->input('category_id')) ? request()->input('category_id') : ''); ?>"
    >

    <?php if($bex->is_course_rating == 1): ?>
    <input
      type="hidden"
      id="ratingKey"
      name="rating"
      value="<?php echo e(!empty(request()->input('rating')) ? request()->input('rating') : ''); ?>"
    >
    <?php endif; ?>

    <input
      type="hidden"
      id="checkedKey"
      name="checked_value"
      value="<?php echo e(!empty(request()->input('checked_value')) ? request()->input('checked_value') : ''); ?>"
    >
    <input
      type="hidden"
      id="minPriceId"
      name="minValue"
      value="<?php echo e(!empty(request()->input('minValue')) ? request()->input('minValue') : ''); ?>"
    >
    <input
      type="hidden"
      id="maxPriceId"
      name="maxValue"
      value="<?php echo e(!empty(request()->input('maxValue')) ? request()->input('maxValue') : ''); ?>"
    >
    <input
      type="hidden"
      id="typeId"
      name="filterValue"
      value="<?php echo e(!empty(request()->input('filterValue')) ? request()->input('filterValue') : ''); ?>"
    >
    <button type="submit" id="submitBtn"></button>
  </form>
  

  <?php
    $maxPrice = App\Course::max('current_price');
    $minPrice = App\Course::min('current_price');
  ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <script src="<?php echo e(asset('assets/front/js/jquery.ui.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/front/js/jquery.nice-select.min.js')); ?>"></script>

  <script>
    $(document).ready(function() {
      // jquery nice select js
      $('select').niceSelect();

      var position = '<?php echo e($bse->base_currency_symbol_position); ?>';
      var symbol = '<?php echo e($bse->base_currency_symbol); ?>';

      // slider range js
      $('#slider-range').slider({
        range: true,
        min: 0,
        max: <?php echo e($maxPrice); ?>,
        values: [
          <?php echo e(!empty(request()->input('minValue')) ? request()->input('minValue') : 0); ?>,
          <?php echo e(!empty(request()->input('maxValue')) ? request()->input('maxValue') : $maxPrice); ?>

        ],
        slide: function(event, ui) {
          //while sliding the price range, this function will show that value
          $('#amount').val((position == 'left' ? symbol : '') + ui.values[0] + (position == 'right' ? symbol : '') + ' - ' + (position == 'left' ? symbol : '') + ui.values[1] + (position == 'right' ? symbol : ''));
        }
      });

      // initially this is showing the price range value beside the 'Price' label
      $('#amount').val((position == 'left' ? symbol : '') + ' ' + $('#slider-range').slider('values', 0) + ' ' + (position == 'right' ? symbol : '') + ' - ' + (position == 'left' ? symbol : '') + ' ' + $('#slider-range').slider('values', 1) + ' ' + (position == 'right' ? symbol : ''));

      // function for input search
      $(document).on('keyup', '#searchInput', function(event) {
        if (event.keyCode === 13) {
            event.preventDefault();
            let searchVal = $('#searchInput').val();
            $('#searchKey').val(searchVal);
            $('#submitBtn').click();
        }
      });

      // function for select a option search
      $(document).on('click', '#categoryId', function() {
        let id;

        if($(this).attr('data-href') != 0) {
          id = $(this).attr('data-href');
        }

        $('#categoryKey').val(id);
        $('#submitBtn').click();
      });

      // function for checkbox search
      $(document).on('click', '.course-type', function() {
        let checkedVal = $('.course-type:checked').val();
        $('#checkedKey').val(checkedVal);
        $('#submitBtn').click();
      });

    // function for checkbox search
    $(document).on('click', '.rating-filter', function() {
        let checkedVal = $('.rating-filter:checked').val();
        $('#ratingKey').val(checkedVal);
        $('#submitBtn').click();
    });

      // function for slider search
      $(document).on('slidestop', '#slider-range', function() {
        let filterPrice = $('#amount').val();
        filterPrice = filterPrice.split('-');
        let min_price = parseInt(filterPrice[0].replace('$', ''));
        let max_price = parseInt(filterPrice[1].replace('$', ''));
        $('#minPriceId').val(min_price);
        $('#maxPriceId').val(max_price);
        $('#submitBtn').click();
      });

      // function for select a option (filter) search
      $(document).on('change', '#filterType', function() {
        let typeVal = $('#filterType').val();
        $('#typeId').val(typeVal);
        $('#submitBtn').click();
      });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("front.$version.layout", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suprgyzi/public_html/core/resources/views/front/course/courses.blade.php ENDPATH**/ ?>