<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8">
  	<meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <title><?php echo e($bs->website_title); ?></title>
  	<link rel="icon" href="<?php echo e(asset('assets/front/img/'.$bs->favicon)); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/login.css')); ?>">
    <style>
    .login-page {
        width: 600px;
    }
    .form {
        max-width: 600px;
    }
    .form button {
        width: 35%;
        padding: 12px;
    }
    p.back-link {
        font-size: 14px;
        text-transform: uppercase;
        margin-bottom: 0px;
        margin-top: 12px;
    }
    </style>
  </head>
  <body>
    <div class="login-page">
      <div class="text-center mb-4">
        <img class="login-logo" src="<?php echo e(asset('assets/front/img/'.$bs->logo)); ?>" alt="">
      </div>
      <div class="form">
        <?php if(session()->has('success')): ?>
          <div class="alert alert-success fade show" role="alert" style="font-size: 14px;">
            <strong>Success!</strong> <?php echo e(session('success')); ?>

          </div>
        <?php endif; ?>
        <form class="login-form" action="<?php echo e(route('admin.forget.mail')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <input type="email" name="email" placeholder="Enter email address"/>
          <?php if($errors->has('email')): ?>
            <p class="text-danger text-left"><?php echo e($errors->first('email')); ?></p>
          <?php endif; ?>
          <button type="submit">Send Mail</button>
        </form>

        <p class="back-link">
          <a href="<?php echo e(route('admin.login')); ?>">&lt;&lt; Back</a>
        </p>
      </div>
    </div>


    <!-- jquery js -->
    <script src="<?php echo e(asset('assets/front/js/jquery-3.3.1.min.js')); ?>"></script>
    <!-- popper js -->
    <script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
    <!-- bootstrap js -->
    <script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
    <!-- Bootstrap Notify -->
    <script src="<?php echo e(asset('assets/admin/js/plugin/bootstrap-notify/bootstrap-notify.min.js')); ?>"></script>

    <?php if(session()->has('warning')): ?>
    <script>
      var content = {};

      content.message = '<?php echo e(session('warning')); ?>';
      content.title = 'Sorry!';
      content.icon = 'fa fa-bell';

      $.notify(content,{
        type: 'warning',
        placement: {
          from: 'top',
          align: 'right'
        },
        showProgressbar: true,
        time: 1000,
        delay: 4000,
      });
    </script>
    <?php endif; ?>
  </body>
</html>
<?php /**PATH /home/suprgyzi/public_html/core/resources/views/admin/forget.blade.php ENDPATH**/ ?>